#!/usr/bin/env python
# Set Plan Bar Color By Dependency.py
# Copyright 2007 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 070212 - Brian - first draft
# 070215 - Brian - debug

#import wx
#import re

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

if debug: print 'Start Script'


def SetPlanBarColor(self):

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drow = Data.Database['ReportRow']
    drt = Data.Database['ReportType']
    dt = Data.Database['Task']
    dd = Data.Database['Dependency']
    da = Data.Database['Assignment']
    dres = Data.Database['Resource']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    # is this a task report
    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
    tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
    if not (ta == 'Task' or tb == 'Task'):
        hint('Use script only with Task reports.')
        return

    # find the selected rows
    sel = self.Report.GetSelectedRows()  # current selection
##    if len(sel) <= 0:
##        hint("Must select at least one task row.")
##        return
    if not sel:
        if not self.Report.table.rows:
            return
        sel = [self.Report.GetGridCursorRow()]  # if no rows are selected, use cursor row

    rows = self.Report.table.rows    # all visible rows in display order
    # get row ids for all selected task rows
    sel_rids = [ rows[x] for x in sel if drow[rows[x]].get('TableName') == 'Task' ]
    if len(sel_rids) < 1:
        hint("Must select at least one task row.")
        return

    sel_taskids = [ drow[x].get('TableID') for x in sel_rids ]  # selected task ids


    # get row ids for all task rows
    all_rids = [ x for x in rows if drow[x].get('TableName') == 'Task' ]

    newcolor = None  # set all rows to default color
    xref = {}  # make it possible to look up rows via their task id
    for rowid in all_rids:
        if drow[rowid].get('PlanBarColor') != newcolor:  # clear color for each row
            change = { 'Table': 'ReportRow', 'ID': rowid, 'PlanBarColor': newcolor }
            Data.Update(change)
        taskid = drow[rowid].get('TableID')
        if taskid:
            xref[taskid] = rowid

# I'll build lists of task id numbers that should receive different colors
# I need to know which rows to color
# 

    pre_taskids = []
    for tid in sel_taskids:
        pre = Data.SearchByColumn(dd, {'TaskID': tid})
        pre_taskids.extend([ dd[x].get('PrerequisiteID') for x in pre if x in dd ])

    pre2_taskids = []
    for tid in pre_taskids:
        pre = Data.SearchByColumn(dd, {'TaskID': tid})
        pre2_taskids.extend([ dd[x].get('PrerequisiteID') for x in pre if x in dd ])

    post_taskids = []
    for tid in sel_taskids:
        post = Data.SearchByColumn(dd, {'PrerequisiteID': tid})
        post_taskids.extend([ dd[x].get('TaskID') for x in post if x in dd ])

    post2_taskids = []
    for tid in post_taskids:
        post = Data.SearchByColumn(dd, {'PrerequisiteID': tid})
        post2_taskids.extend([ dd[x].get('TaskID') for x in post if x in dd ])

    # set color for each listed row as specified
    def set_color(newcolor, tasklist):
        for taskid in tasklist:
            # change row to new color
            if taskid in xref and drow[xref[taskid]].get('PlanBarColor') != newcolor:
                change = { 'Table': 'ReportRow', 'ID': xref[taskid], 'PlanBarColor': newcolor }
                Data.Update(change)

    red = 'FF0000'
    orange = 'FF7500'
    yellow ='FFFF00'
    green = '00FF00'
    blue = '0000FF'
    indigo = '4B0082'
    violet = '8B00FF'

    set_color(orange, pre2_taskids)
    set_color(indigo, post2_taskids)
    set_color(yellow, pre_taskids)
    set_color(blue, post_taskids)
    set_color(green, sel_taskids)

    Data.SetUndo('Set Plan Bar Color By Dependency')


SetPlanBarColor(self)

if debug: print 'End Script'

